#ifndef __DEBUG_H_
#define __DEBUG_H_


//#define _DEBUG 1
#ifdef _DEBUG

#define MSG_DEBUG_VERBOSE(...) do { \
	printf("File is %s, Function is:%s, Line is:%d --->  ", __FILE__, __FUNCTION__, __LINE__); \
	printf(__VA_ARGS__); \
} while(0)
	
#define MSG_DEBUG_SIMPLE(...) do { \
	printf(__VA_ARGS__); \
} while(0)
	
#define MSG_ERROR_VERBOSE(...) do { \
	perror("perror"); \
	printf("File is %s, Function is:%s, Line is:%d --->  ", __FILE__, __FUNCTION__, __LINE__); \
	printf(__VA_ARGS__); \
} while(0)
	
#define MSG_ERROR_SIMPLE(...) do { \
	printf(__VA_ARGS__); \
} while(0)
	
extern void debug_to_file(const char *cmd, ...); 
#define DEBUG_TO_FILE(...) do { \
	debug_to_file("File is %s, Function is:%s, Line is:%d --->  ", __FILE__, __FUNCTION__, __LINE__); \
	debug_to_file(__VA_ARGS__); \
} while(0)

extern void debug_to_console(const char *cmd, ...); 
#define DEBUG_TO_CONSOLE(...) do { \
	debug_to_console("File is %s, Function is:%s, Line is:%d --->  ", __FILE__, __FUNCTION__, __LINE__); \
	debug_to_console(__VA_ARGS__); \
} while(0)

	
#else
	
#define MSG_DEBUG_VERBOSE(...) do {;} while(0)
#define MSG_DEBUG_SIMPLE(...)  do {;} while(0)	
#define MSG_ERROR_VERBOSE(...) do {;} while(0)	
#define MSG_ERROR_SIMPLE(...)  do {;} while(0)	
#define DEBUG_TO_FILE(...)     do {;} while(0)		
#define DEBUG_TO_CONSOLE(...)  do {;} while(0)	


#endif

#ifdef __STDC__

#define COMPILE_INFO do \
{ \
	MSG_DEBUG_VERBOSE("This project/file is compiled at %s on %s, ansic supported\n", __TIME__, __DATE__);\
}while(0)
	
#else
	
#define COMPILE_INFO do \
{ \
	MSG_DEBUG_VERBOSE("This project/file is compiled at %s on %s, ansic NOT supported\n", __TIME__, __DATE__);\
}while(0)	
	
#endif

#endif
